<?php

/**
 * Class that operate on table 'productcatunit'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-10-22 14:58
 */
class ProductcatunitMySqlDAO implements ProductcatunitDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProductcatunitMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM productcatunit WHERE productcatunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM productcatunit';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM productcatunit ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param productcatunit primary key
     */
    public function delete($productcatunitid) {
        $sql = 'DELETE FROM productcatunit WHERE productcatunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($productcatunitid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProductcatunitMySql productcatunit
     */
    public function insert($productcatunit) {
        $sql = 'INSERT INTO productcatunit (unitid, productcatid, productnumber, productcatunitdate, userid, conditions) VALUES (?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productcatunit->unitid);
        $sqlQuery->setNumber($productcatunit->productcatid);
        $sqlQuery->setNumber($productcatunit->productnumber);
        $sqlQuery->set($productcatunit->productcatunitdate);
        $sqlQuery->setNumber($productcatunit->userid);
        $sqlQuery->setNumber($productcatunit->conditions);

        $id = $this->executeInsert($sqlQuery);
        $productcatunit->productcatunitid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProductcatunitMySql productcatunit
     */
    public function update($productcatunit) {
        $sql = 'UPDATE productcatunit SET unitid = ?, productcatid = ?, productnumber = ?, productcatunitdate = ?, userid = ?, conditions = ? WHERE productcatunitid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productcatunit->unitid);
        $sqlQuery->setNumber($productcatunit->productcatid);
        $sqlQuery->setNumber($productcatunit->productnumber);
        $sqlQuery->set($productcatunit->productcatunitdate);
        $sqlQuery->setNumber($productcatunit->userid);
        $sqlQuery->setNumber($productcatunit->conditions);

        $sqlQuery->setNumber($productcatunit->productcatunitid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM productcatunit';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByUnitid($value) {
        $sql = 'SELECT * FROM productcatunit WHERE unitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductcatid($value) {
        $sql = 'SELECT * FROM productcatunit WHERE productcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductnumber($value) {
        $sql = 'SELECT * FROM productcatunit WHERE productnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductcatunitdate($value) {
        $sql = 'SELECT * FROM productcatunit WHERE productcatunitdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM productcatunit WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM productcatunit WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByUnitid($value) {
        $sql = 'DELETE FROM productcatunit WHERE unitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductcatid($value) {
        $sql = 'DELETE FROM productcatunit WHERE productcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductnumber($value) {
        $sql = 'DELETE FROM productcatunit WHERE productnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductcatunitdate($value) {
        $sql = 'DELETE FROM productcatunit WHERE productcatunitdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM productcatunit WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM productcatunit WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProductcatunitMySql
     */
    protected function readRow($row) {
        $productcatunit = new Productcatunit();

        $productcatunit->productcatunitid = isset($row['productcatunitid']) ? $row['productcatunitid'] : '';
        $productcatunit->unitid = isset($row['unitid']) ? $row['unitid'] : '';
        $productcatunit->productcatid = isset($row['productcatid']) ? $row['productcatid'] : '';
        $productcatunit->productnumber = isset($row['productnumber']) ? $row['productnumber'] : '';
        $productcatunit->productcatunitdate = isset($row['productcatunitdate']) ? $row['productcatunitdate'] : '';
        $productcatunit->userid = isset($row['userid']) ? $row['userid'] : '';
        $productcatunit->conditions = isset($row['conditions']) ? $row['conditions'] : '';

        return $productcatunit;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProductcatunitMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>